import { Observable, throwError, timer } from 'rxjs';
import { mergeMap } from 'rxjs/operators';

export interface IncreasingTimerRetryStrategyOptions {
  maxRetryAttempts?: number;
  scalingDuration?: number;
}

export const DEFAULT_MAX_RETRY_ATTEMPTS = 3;
export const DEFAULT_SCALING_DURATION = 1000;

export const increasingTimerRetryStrategy = <T>({
  maxRetryAttempts = DEFAULT_MAX_RETRY_ATTEMPTS,
  scalingDuration = DEFAULT_SCALING_DURATION,
}: IncreasingTimerRetryStrategyOptions = {}) => (attempts: Observable<T>) => {
  return attempts.pipe(
    mergeMap((error, i) => {
      const retryAttempt = i + 1;
      if (retryAttempt > maxRetryAttempts) {
        return throwError(error);
      }
      return timer(retryAttempt * scalingDuration);
    }),
  );
};
