import React from 'react';

const injectReducerHoc = config => (WrappedComponent) => {
  class InjectReducer extends React.Component {
    componentDidMount() {
      global.reduxStore.injectReducer(config.name, config.reducers);
    }

    render() {
      return React.createElement(WrappedComponent, this.props);
    }
  }

  return InjectReducer;
};

export default injectReducerHoc;
