import { ModuleName } from 'modules/issues/types';

// в чистом виде - ^\s*(\d+)$|(?:\/(?:${ModuleName.Issue}|${ModuleName.Ticket})\/(\d+))
export const issueUrlRegExp = new RegExp(
  `\^\\s\*\(\\d\+\)\\s\*\$\|\(\?:\\/\(\?:${ModuleName.Issue}\|${ModuleName.Ticket})\\/\(\\d\+\)\)`,
);

export const getIssueIdFormIssueUrl = (str: string) => {
  const match = str.match(issueUrlRegExp);
  if (!match) {
    throw new Error('Wrong Target Id format');
  }

  return Number(match[1] || match[2]);
};
