export const addPrefixToKey = key => `space.${key}`;

export const setData = (key, data) => {
  let jsonFilter;
  try {
    jsonFilter = JSON.stringify(data);
  } catch (e) {
    /*
    * Сейчас если будет какая-то проблема с данными
    * никто это не узнает - нехорошо
    * */
    console.error(e); // eslint-disable-line no-console
  }

  if (jsonFilter !== undefined) {
    localStorage.setItem(addPrefixToKey(key), jsonFilter);
  }
};

export const getData = (key) => {
  try {
    return JSON.parse(localStorage.getItem(addPrefixToKey(key)));
  } catch (e) {
    return null;
  }
};

class LocalStorage {
  static setItem = setData;
  static getItem = getData;
  static addPrefixToKey = addPrefixToKey;
}

export default LocalStorage;
