import { Ref, MutableRefObject } from 'react';

type Nullable<T> = T | null;

export class MergeRef<T> {
  private _current: Nullable<T> = null;

  private _refs: (Ref<T> | undefined)[];

  public set refs(refs: (Ref<T> | undefined)[]) {
    this._refs = refs;
  }

  public get current(): Nullable<T> {
    return this._current;
  }

  public set current(node: Nullable<T>) {
    this._current = node;

    this.updateRefs();
  }

  public asCallback = (node: Nullable<T>) => {
    this.current = node;
  };

  private updateRefs(): void {
    if (Array.isArray(this._refs)) {
      this._refs.forEach((ref) => {
        if (typeof ref === 'function') {
          ref(this._current);
        } else if (ref != null) {
          (ref as MutableRefObject<Nullable<T>>).current = this._current;
        }
      });
    }
  }
}
