import Immutable from 'immutable';

export default (actionTypes, behaviors, initItemState = {}) => {
  return (state = {}, action = {}) => {
    const name = action && action.meta && action.meta.name;
    if (!name) {
      return state;
    }

    if (action.type === actionTypes.DESTROY) {
      const result = { ...state };
      delete result[name];
      return result;
    }

    const behavior = behaviors[action.type];
    if (behavior) {
      const itemState = Immutable.fromJS(state[name] || initItemState);
      const result = behavior(itemState, action).toJS();
      return result === itemState ? state : { ...state, [name]: result };
    }

    return state;
  };
};
