/* eslint-disable no-param-reassign */

export default (actionTypes, behaviors, initItemState = {}, slug = 'name', initState = {}) => (
  state = initState,
  action = {},
) => {
  if (action.type === 'LOCAL_STORAGE' && behaviors.LOCAL_STORAGE) {
    return Object.entries(state).reduce((ac, [key, value]) => {
      ac[key] = behaviors.LOCAL_STORAGE(value);
      return ac;
    }, {});
  }

  const name = action && action.meta && action.meta[slug];
  if (name == null) {
    return state;
  }

  const behavior = behaviors[action.type];
  if (behavior) {
    const itemState = state[name];
    const result = behavior(itemState || initItemState, action);
    return result === itemState ? state : { ...state, [name]: result };
  }

  return state;
};
