import get from 'lodash/get';

type Selector = (state: any) => any;

interface Selectors {
  [key: string]: Selector;
}

export default (path: string, selectors: Selectors) =>
  Object.keys(selectors).reduce(
    (ac: Selectors, currentValue) => ({
      ...ac,
      [currentValue]: state => selectors[currentValue](get(state, path)),
    }),
    {},
  );
