import Immutable from 'immutable';

export default (actionTypes, behaviors, initItemState = {}) => {
  return (state = {}, action = {}) => {
    const behavior = behaviors[action.type];
    if (behavior) {
      const itemState = Immutable.fromJS(state || initItemState);
      return behavior(itemState, action).toJS();
    }

    return state;
  };
};
