import * as React from 'react';
import { connect } from 'react-redux';
import { initialize } from 'redux-form';

interface Props {
  initialValues?: any;
  dispatch: any;
  form: string;
}

export default WrappedComponent => {
  class FixReinitialize extends React.Component<Props> {
    public componentDidUpdate(prevProps) {
      if (this.props.initialValues !== prevProps.initialValues) {
        this.props.dispatch(initialize(this.props.form, this.props.initialValues));
      }
    }

    public render() {
      return React.createElement(WrappedComponent, this.props);
    }
  }

  return connect()(FixReinitialize);
};
