import { get, post } from 'api/common';
import { RequestFunction, RequestMethod } from './requestify.types';

interface Requestify {
  <TReqBody extends {}>(endpoint: string, method?: RequestMethod): RequestFunction<TReqBody, void>;

  <TReqBody extends void, TResBody extends {}>(
    endpoint: string,
    method?: RequestMethod,
  ): RequestFunction<TReqBody, TResBody>;

  <TReqBody extends {}, TResBody extends {}>(
    endpoint: string,
    method?: RequestMethod,
  ): RequestFunction<TReqBody, TResBody>;
}

const requestify: Requestify = (endpoint, method = 'GET') => {
  return (requestBody) => {
    const requestObj: {
      url: string;
      data?: unknown;
    } = {
      url: endpoint,
    };

    if (requestBody) {
      requestObj.data = method === 'GET' ? requestBody : JSON.stringify(requestBody);
    }

    if (method === 'GET') {
      return get(requestObj);
    }
    if (method === 'POST') {
      return post({
        ...requestObj,
        contentType: 'application/json; charset=utf-8',
      });
    }

    const errorText = `Unavailable request method in requestify: ${method}.`;

    console.error(errorText);
    return Promise.reject(new Error(errorText));
  };
};

export { requestify };
