import React from 'react';
import getDisplayName from 'utils/getDisplayName';
import resize from 'utils/resize';

const resizeNotify = config => WrappedComponent => {
  class ResizeNotify extends React.Component {
    componentDidUpdate(prevProps) {
      const { props } = this;
      const { resizeProps } = props;

      if (resizeProps.some(key => props[key] !== prevProps[key])) {
        resize();
      }
    }

    render() {
      const { resizeProps, ...passPropsThrough } = this.props;

      return <WrappedComponent {...passPropsThrough} />;
    }
  }
  ResizeNotify.displayName = `WithResizeNotify(${getDisplayName(WrappedComponent)})`;
  ResizeNotify.defaultProps = {
    resizeProps: [],
    ...config,
  };

  return ResizeNotify;
};

export default resizeNotify;
