export type Callback = () => void;

export type Unsubscribe = Callback;

export const runIfTabVisibleOnce = (callback: Callback): Unsubscribe => {
  if (document.visibilityState === 'visible') {
    callback();

    return () => {};
  }

  const unsubscribe = () => {
    // eslint-disable-next-line no-use-before-define
    document.removeEventListener('visibilitychange', handleVisibilityChange);
  };

  const handleVisibilityChange = () => {
    if (document.visibilityState === 'visible') {
      callback();
      unsubscribe();
    }
  };

  document.addEventListener('visibilitychange', handleVisibilityChange);

  return unsubscribe;
};
