export const skipCallWithSameArgs = <T, Args extends Array<T>, Return>(
  func: (...args: Args) => Return,
): ((...args: Args) => Return | undefined) => {
  let lastArgs: Args | undefined;

  return function(...args) {
    let shouldCall = lastArgs?.length !== args.length;

    if (!shouldCall) {
      for (let i = 0; i < args.length; i += 1) {
        if (!Object.is(args[i], lastArgs![i])) {
          shouldCall = true;
          break;
        }
      }
    }

    if (!shouldCall) {
      return undefined;
    }

    lastArgs = args;

    return func(...args);
  };
};
