const trackerUrlRegExp = /st\.(?:test\.)?yandex-team\.ru\/([a-zA-Z]+-\d+)/;

export const isTrackerUrl = (anything: unknown) => {
  return typeof anything === 'string' && trackerUrlRegExp.test(anything);
};

export const getIssueKeyFromTrackerUrl = (trackerUrl) => {
  return trackerUrl.match(trackerUrlRegExp)[1];
};
