const nodeConvertor = args => {
  const { node, func, chidlrenSlug = 'items', newChildrenSlug = 'items' } = args;

  if (!node) {
    return null;
  }

  if (!func) {
    return node;
  }

  const newNode = func(node);
  const chidlren = node[chidlrenSlug];
  if (Array.isArray(chidlren)) {
    newNode[newChildrenSlug] = chidlren.map(child => nodeConvertor({ ...args, node: child }));
  }

  return newNode;
};

export default nodeConvertor;
