/** @deprecated use https://developer.mozilla.org/ru/docs/Web/API/URL */
export default {
  serialize(obj) {
    const resultArr = [];

    Object.entries(obj).forEach(([key, val]) => {
      if (val != null && val !== '') {
        let formatVal = val;
        if (typeof val === 'object') {
          try {
            formatVal = JSON.stringify(val);
          } catch (e) {
            console.error(e);
          }
        }

        resultArr.push(`${key}=${encodeURIComponent(formatVal)}`);
      }
    });

    return resultArr.join('&');
  },
  queryToObject(str) {
    if (!(str && typeof str === 'string')) {
      return null;
    }

    return str
      .replace('?', '')
      .split('&')
      .reduce((ac, cv) => {
        const arr = cv.split('=');
        let parsedVal = arr[1];
        try {
          parsedVal = decodeURIComponent(parsedVal);
        } catch (e) {
          /* empty catch */
        }

        try {
          parsedVal = JSON.parse(parsedVal);
        } catch (e) {
          /* empty catch */
        }

        return {
          ...ac,
          [arr[0]]: parsedVal,
        };
      }, {});
  },
};
