/* global window*/
import { Children, Component } from 'react';
import throttle from 'lodash/throttle';
import contextProps from './contextProps';

class ProviderWindowResize extends Component {
  static getWindowSize() {
    return {
      height: window.innerHeight,
      width: window.innerWidth,
    };
  }

  constructor(props) {
    super(props);

    this.listeners = [];
    this.handleWindowResize = throttle(this.handleWindowResize, 100);
  }

  getChildContext() {
    return {
      addListener: this.addListener,
      removeListener: this.removeListener,
      getWindowSize: ProviderWindowResize.getWindowSize,
    };
  }

  componentDidMount() {
    window.addEventListener('resize', this.handleWindowResize);
  }

  componentWillUnmount() {
    window.removeEventListener('resize', this.handleWindowResize);
  }

  addListener = (listener) => { this.listeners.push(listener); };
  removeListener = (_listener) => {
    this.listeners = this.listeners.filter(listener => _listener !== listener);
  };

  handleWindowResize = () => {
    const size = ProviderWindowResize.getWindowSize();
    this.listeners.forEach((listener) => {
      listener(size);
    });
  };

  render() {
    return Children.only(this.props.children);
  }
}

ProviderWindowResize.childContextTypes = contextProps;

export default ProviderWindowResize;
