/* global document*/
/* eslint-disable no-underscore-dangle */

import React from 'react';
import getDisplayName from 'utils/getDisplayName';
import hoistNonReactStatic from 'hoist-non-react-statics';
import contextProps from './contextProps';

const connectWindowSize = (WrappedComponent) => {
  class WindowResize extends React.Component {
    constructor(props, context) {
      super(props, context);

      this.state = { size: context.getWindowSize() };
    }

    componentDidMount() {
      this.context.addListener(this.handleWindowResize);
    }

    componentWillUnmount() {
      this.context.removeListener(this.handleWindowResize);
    }

    handleWindowResize = (size) => {
      this.setState({ size });
    };

    render() {
      return React.createElement(WrappedComponent, {
        ...this.props,
        windowSize: this.state.size,
      });
    }
  }

  WindowResize.displayName = `WindowResize(${getDisplayName(WrappedComponent)})`;
  WindowResize.contextTypes = contextProps;
  return hoistNonReactStatic(WindowResize, WrappedComponent);
};

export default connectWindowSize;
