/*
eslint-disable
no-underscore-dangle,
react/no-find-dom-node
*/

import React from 'react';
import PropTypes from 'prop-types';
import ReactDOM from 'react-dom';
import hoistNonReactStatic from 'hoist-non-react-statics';

const getMethodName = type => `handleDocument${type.charAt(0).toUpperCase() + type.slice(1)}`;

const getEventHandle = (context, type) => {
  const methodName = getMethodName(type);

  const handle = (e) => {
    const wrappedComponent = context.__wrappedComponent; // eslint-disable-line no-underscore-dangle
    if (wrappedComponent && typeof wrappedComponent[methodName] === 'function') {
      const domNode = context.__domNode;
      const isOutside = !domNode || !domNode.contains(e.target);
      wrappedComponent[methodName](e, isOutside);
    }
  };

  handle.add = () => { document.addEventListener(type, handle, true); };
  handle.remove = () => { document.removeEventListener(type, handle, true); };

  return handle;
};

const withDocumentEvents = config => (WrappedComponent) => {
  const componentName = WrappedComponent.displayName || WrappedComponent.name;

  class EnhancedComponent extends React.Component {
    static propTypes = {
      events: PropTypes.instanceOf(Array),
    }

    static defaultProps = {
      ...config,
    }

    constructor(props) {
      super(props);

      const { events } = props;

      let eventHandles = [];
      if (Array.isArray(events)) {
        eventHandles = events.map(event => getEventHandle(this, event));
      }
      this.eventHandles = eventHandles;
    }

    componentDidMount() {
      this.eventHandles.forEach(handle => handle.add());
    }

    componentWillUnmount() {
      this.eventHandles.forEach(handle => handle.remove());
    }

    ref = (component) => {
      this.__wrappedComponent =
        ((component && component.__wrappedComponent) ? component.__wrappedComponent : component);
      this.__domNode = ReactDOM.findDOMNode(component);
    }

    render() {
      return React.createElement(WrappedComponent, {
        ...this.props,
        ref: this.ref,
      });
    }
  }

  EnhancedComponent.displayName = `WithDocumentEvents(${componentName})`;

  return hoistNonReactStatic(EnhancedComponent, WrappedComponent);
};

export default withDocumentEvents;
