/*
eslint-disable
react/prefer-stateless-function
*/

import React from 'react';
import getDisplayName from 'utils/getDisplayName';
import hoistNonReactStatic from 'hoist-non-react-statics';

const withRefSupport = WrappedComponent => {
  class WithRefSupport extends React.Component {
    render() {
      return React.createElement(WrappedComponent, this.props);
    }
  }

  WithRefSupport.displayName = `WithRefSupport(${getDisplayName(WrappedComponent)})`;

  return hoistNonReactStatic(WithRefSupport, WrappedComponent);
};

export default withRefSupport;
