import { ValidationError } from 'yup';
import get from 'lodash/get';
import set from 'lodash/set';

/**
 * Transform Yup ValidationError to a more usable object
 */
export function yupToFormErrors<Values>(yupError: ValidationError): any {
  let errors: any = {};
  if (yupError.inner) {
    if (yupError.inner.length === 0) {
      return set(errors, yupError.path, yupError.message);
    }
    // eslint-disable-next-line no-restricted-syntax
    for (const err of yupError.inner) {
      if (!get(errors, err.path)) {
        errors = set(errors, err.path, err.message);
      }
    }
  }
  return errors;
}
