import { fetchExtended } from 'utils/fetchExtended';

const ONLINE_DELAY = 5000;
const OFFLINE_DELAY = 1000;
const RETRY_DELAY = 500;
const RETRY_TIMES = 3;

let workerConnected = false;
let networkConnected = true;
let portPool: SharedWorker['port'][] = [];

const getDelay = () => (networkConnected ? ONLINE_DELAY : OFFLINE_DELAY);
const getRetryOptions = () => ({
  count: networkConnected ? RETRY_TIMES : 0,
  delay: RETRY_DELAY,
});

const resolveCb = (_res) => {
  networkConnected = true;
  portPool.forEach((port) => {
    port?.postMessage?.({ status: 'online' });
  });
};

const rejectCb = (_error) => {
  networkConnected = false;
  portPool.forEach((port) => {
    port?.postMessage?.({ status: 'offline' });
  });
};

const checkConnect = (url: string) => {
  self.setTimeout(function tick() {
    fetchExtended(url, { retryOptions: getRetryOptions(), timeout: 5000 })
      .then(resolveCb)
      .catch(rejectCb)
      .finally(() => {
        self.setTimeout(tick, getDelay());
      });
  }, getDelay());
};

self.addEventListener(
  'connect',
  (e) => {
    portPool.push(e?.ports[0]);
    e.source.addEventListener(
      'message',
      (ev) => {
        if (ev.data[0] === 'connect') {
          if (workerConnected === false) {
            e?.source?.postMessage?.('ConnectionChecker worker init');
            checkConnect(ev.data[1]);
            workerConnected = true;
          } else {
            e?.source?.postMessage?.('ConnectionChecker worker already inited');
          }
        }
      },
      false,
    );
    e.source.start();
  },
  false,
);
