export enum MessageType {
  SEARCH,
  LOAD,
}

export type SearchMessage =
  | {
      type: MessageType.LOAD;
      data: GroupItem[];
    }
  | {
      type: MessageType.SEARCH;
      data: string;
    };

export type Item = {
  id: number;
  target?: string;
  name?: string;
  templateType?: string;
  canRead?: boolean;
  type: undefined;
};

export type Group = {
  id: number;
  target?: undefined;
  name?: string;
  url?: string;
  items: Item[];
  type: 'group';
};

export type GroupItem = Group | Item;

export interface SearchWorker extends Worker {
  postMessage(message: GroupItem[]): void;
  onmessage: (message: MessageEvent<SearchMessage>) => void;
}
