import { GroupItem, MessageType, SearchWorker } from './search.types';

const ctx: SearchWorker = (self as unknown) as SearchWorker;

let data: GroupItem[];

let flatData;

const flattenItems = () => {
  if (!flatData && data?.length) {
    flatData = data.reduce<GroupItem[]>((acc, item) => {
      acc.push(item);
      if (item.type === 'group') {
        acc.push(...item.items);
      }
      return acc;
    }, []);
  }

  return flatData || [];
};

const contains = (item: GroupItem, term: string): boolean => {
  const lowerTerm = term.toLowerCase();
  const name = item.name?.toLowerCase() || '';
  const target = item.target?.toLowerCase() || '';
  return name.includes(lowerTerm) || target.includes(lowerTerm);
};

const findItems = (term: string) =>
  term
    ? data.reduce<GroupItem[]>((acc, item) => {
        if (contains(item, term)) {
          acc.push(item);
          if (item.type === 'group') {
            acc.push(...item.items);
          }
        } else if (item.type === 'group') {
          const foundSubItems = item.items.filter((item) => contains(item, term));
          if (foundSubItems.length) {
            acc.push(item, ...foundSubItems);
          }
        }
        return acc;
      }, [])
    : flattenItems();

ctx.onmessage = (message) => {
  switch (message.data.type) {
    case MessageType.SEARCH:
      ctx.postMessage(findItems(message.data.data));
      break;
    case MessageType.LOAD:
      data = message.data.data;
      flatData = undefined;
      ctx.postMessage(flattenItems());
      break;
    default:
      return;
  }
};
