const resultNode = document.getElementById('result');
const clearLocalStorageNode = document.getElementById('clearLocalStorage');
const deleteIndexedDB = document.getElementById('deleteIndexedDB');

clearLocalStorageNode.addEventListener('click', function() {
  localStorage.clear();
  resultNode.innerText = 'localStorage успешно сброшен';
});

deleteIndexedDB.addEventListener('click', async function() {
  const indexedDB = await window.indexedDB;
  const databases = await indexedDB.databases();

  databases.forEach(({name}) => {
    const deleteRequest = indexedDB.deleteDatabase(name)
    deleteRequest.onsuccess = () => {
      resultNode.innerText += `Таблица ${name} в indexedDB успешно сброшена\n`;
    }
    deleteRequest.onerror = () => {
      resultNode.innerText += `Ошибка: ${deleteRequest.error}\n`;
    }
  })
})
