/* eslint-disable no-console */
import path from 'path';
import fs from 'fs';
import webpack from 'webpack';
import devConfig from './webpack/dev.config';
import prodConfig from './webpack/prod.config';

const NODE_ENV = {
  val: process.env.NODE_ENV,
  constant: {
    dev: 'development',
    prod: 'production',
  },
};

console.log('NODE ENV: ', NODE_ENV.val);

const DIST_PATH = path.join(__dirname, 'dist');

interface Props {
  devFeature?: boolean;
  fullversion?: string;
  publicPath?: string;
}

export default function config(env: Props = {}): webpack.Configuration {
  console.log('ENV ARGS: ', env);

  let APP_VERSION = env.fullversion || 'DEV';
  let distPath = DIST_PATH;
  if (NODE_ENV.val === NODE_ENV.constant.prod) {
    fs.writeFileSync('./frontend.version', APP_VERSION);
    distPath = path.join(__dirname, 'dist', APP_VERSION);
  }

  console.log('VERSION: ', APP_VERSION);

  const options = {
    rootDirName: __dirname,
    distPath,
    env: NODE_ENV.val,
    ...env,
    version: APP_VERSION,
  };

  switch (NODE_ENV.val) {
    case NODE_ENV.constant.dev:
      return devConfig(options);
    default:
      return prodConfig(options);
  }
}
