import React, { PureComponent } from 'react';

interface Props extends React.SVGAttributes<SVGElement> {
  glyph: string;
}

export default class Icon extends PureComponent<Props> {
  public static defaultProps = {
    glyph: '',
    className: 'icon',
  };

  public render() {
    const { glyph, ...restProps } = this.props;

    return (
      <svg {...restProps}>
        <use xlinkHref={`#${glyph}`} />
      </svg>
    );
  }
}
