const fs = require('fs');
const PLUGIN_NAME = 'RumInlinePlugin';
const RUM_PLACEHOLDER = ['<script src="/dist/bundle.rumInline.js">', '</script>'];
const checkPlaceholderInPage = (pageHtml) => pageHtml.includes(RUM_PLACEHOLDER.join(''));

class RumInlinePlugin {
  constructor(appVersion = '') {
    this.appVersion = appVersion;
    this.rumInlineScript = '';
    this.mode = process.env.NODE_ENV;
  }
  apply(compiler) {
    compiler.hooks.compilation.tap(PLUGIN_NAME, (compilation) => {
      if (compiler.options.mode === 'production') {
        compilation.hooks.afterOptimizeChunkAssets.tap(PLUGIN_NAME, (chunks) => {
          chunks.forEach((chunk) => {
            if (chunk.name === 'rumInline') {
              const filename = chunk.files[0];
              this.rumInlineScript = compilation.assets[filename].source();
            }
          });
        });
      }
    });

    compiler.hooks.done.tap(PLUGIN_NAME, () => {
      if (compiler.options.mode === 'production') {
        const mainPageName = this.mode === 'production' ? './index.html' : './dev.html';
        const mainPageAsString = fs.readFileSync(mainPageName, 'UTF8');
        if (checkPlaceholderInPage(mainPageAsString)) {
          const updatedManPageAsString = mainPageAsString.replace(
            RUM_PLACEHOLDER.join(''),
            `<script nonce="<!--##NoncePlaceholder-->">${this.rumInlineScript}</script>`,
          );
          fs.writeFileSync(mainPageName, updatedManPageAsString);
        }
      }
    });
  }
}

module.exports = RumInlinePlugin;
