import json
import logging

from infra.yasm.unistat import global_unistat, AggregationType, SuffixType


class Stat(object):

    def __init__(self, signal_name, prj_name):
        self.logger = logging.getLogger(self.__class__.__name__)
        self.signal_name = signal_name
        self.logger.info("Stat instance created signal %s", signal_name)
        self.metric = global_unistat.create_float(
            name=signal_name,
            tags=[('prj', prj_name)],
            suffix=SuffixType.Absolute,
            aggregation_type=AggregationType.LastValue
        )
        self.logger.debug(global_unistat.to_json())

    def send_signal(self, value):
        self.logger.info("Signal sent [%s]=[%d]", self.signal_name, value)
        self.metric.push(value)

    @staticmethod
    def get_stats():
        return json.loads(global_unistat.to_json())
