import aiohttp
from enum import Enum
from crm.supskills.common.direct_client.structs.general import from_dict
from crm.supskills.common.direct_client.structs.structs.account_management import AccountManagementResponse, Account
from crm.supskills.common.deploy_logger import create_logger

logger = create_logger('direct_api_v4_logger')


class DirectKeyError(KeyError):
    pass


class DirectAPIError(TypeError):
    pass


class DirectNetError(Exception):
    pass


class EnvType(Enum):
    testing = 'testing'
    tests = 'tests'
    production = 'production'
    development = 'development'


class Direct4:

    def __init__(self, env_type: EnvType = EnvType.testing, oauth_token: str = None):
        self.link = 'https://api.test.direct.yandex.ru:14443/live/v4/json/' \
            if env_type == EnvType.testing else 'https://ipv6.api.direct.yandex.ru/live/v4/json/'
        self.oauth_token = oauth_token

    async def _get_params(self, method: str, param: dict) -> dict:
        return {
            'param': param,
            'method': method,
            'login': 'yndx-robot-supskills',
            'locale': 'en',
            'application_id': 'chatbot_persistent',
            'persistent_token': self.oauth_token
        }

    async def _send_request(self, parameters_data: dict) -> dict:
        try:
            async with aiohttp.request('post', self.link, json=parameters_data) as response:
                return await response.json()
        except Exception as e:
            logger.debug('requests.post failed: %s', str(e))
            raise DirectNetError from e

    async def get_account_management(self, client_login: str) -> [Account]:
        parameters_data = self._get_params(
            method='AccountManagement',
            param={'Action': 'Get', 'SelectionCriteria': {'Logins': [client_login]}}
        )
        logger.info('Request to API v4 AccountManagement')
        response = await self._send_request(await parameters_data)
        logger.info('Response from API v4 AccountManagement, body is None: %s.', str(response is None))
        if isinstance(response, dict) and 'data' in response.keys():
            result_class: AccountManagementResponse = from_dict(AccountManagementResponse, response['data'])
            return result_class.Accounts
        logger.debug('DirectAPIError: %s', str(response))
        raise DirectAPIError(f'Error: {str(response)}')
