from crm.supskills.common.direct_client.structs.structs.campaigns import result as campaigns_result
from crm.supskills.common.direct_client.structs.parameters.campaigns import params as campaigns_params
from crm.supskills.common.direct_client.structs.structs.ad_groups import result as ad_groups_result
from crm.supskills.common.direct_client.structs.parameters.ad_groups import params as ad_groups_params
from crm.supskills.common.direct_client.structs.structs.ads import result as ads_result
from crm.supskills.common.direct_client.structs.parameters.ads import params as ads_params
from crm.supskills.common.direct_client.structs.structs.changes import result as changes_result
from crm.supskills.common.direct_client.structs.parameters.changes import params as changes_params
from crm.supskills.common.direct_client.structs.structs.feeds import result as feeds_result
from crm.supskills.common.direct_client.structs.parameters.feeds import params as feeds_params
from crm.supskills.common.direct_client.structs.structs.turbopages import result as turbopages_result
from crm.supskills.common.direct_client.structs.parameters.turbopages import params as turbopages_params
from crm.supskills.common.direct_client.structs.structs.bidmodifiers import result as bidmodifiers_result
from crm.supskills.common.direct_client.structs.parameters.bidmodifiers import params as bidmodifiers_params
from crm.supskills.common.direct_client.structs.structs.keywords import result as keywords_result
from crm.supskills.common.direct_client.structs.parameters.keywords import params as keywords_params
from crm.supskills.common.direct_client.structs.structs.clients import result as clients_result
from crm.supskills.common.direct_client.structs.parameters.clients import params as clients_params
from crm.supskills.common.direct_client.structs.structs.audiencetargets import result as audiencetargets_result
from crm.supskills.common.direct_client.structs.parameters.audiencetargets import params as audiencetargets_params


class Service:
    def __init__(self, link: str, params=None, result=None, method='get'):
        self.link: str = link
        self.params = params
        self.result = result
        self.method: str = method


Ads = Service('ads', ads_params, ads_result)
AdGroups = Service('adgroups', ad_groups_params, ad_groups_result)
Campaigns = Service('campaigns', campaigns_params, campaigns_result)
Changes = Service('changes', changes_params, changes_result, 'check')
Feeds = Service('feeds', feeds_params, feeds_result)
TurboPages = Service('turbopages', turbopages_params, turbopages_result)
Keywords = Service('keywords', keywords_params, keywords_result)
BidModifiers = Service('bidmodifiers', bidmodifiers_params, bidmodifiers_result)
AudienceTargets = Service('audiencetargets', audiencetargets_params, audiencetargets_result)
Clients = Service('clients', clients_params, clients_result)
