from enum import Enum


class AdGroupTypesEnum(str, Enum):
    DYNAMIC_TEXT_AD_GROUP = 'DYNAMIC_TEXT_AD_GROUP'
    MOBILE_APP_AD_GROUP = 'MOBILE_APP_AD_GROUP'
    TEXT_AD_GROUP = 'TEXT_AD_GROUP'
    CPM_BANNER_AD_GROUP = 'CPM_BANNER_AD_GROUP'
    CPM_VIDEO_AD_GROUP = 'CPM_VIDEO_AD_GROUP'
    SMART_AD_GROUP = 'SMART_AD_GROUP'


class AdGroupSubtypeEnum(str, Enum):
    WEBPAGE = 'WEBPAGE'
    FEED = 'FEED'
    KEYWORDS = 'KEYWORDS'
    USER_PROFILE = 'USER_PROFILE'
    NONE = 'NONE'


class DeviceTypeEnum(str, Enum):
    DEVICE_TYPE_MOBILE = 'DEVICE_TYPE_MOBILE'
    DEVICE_TYPE_TABLET = 'DEVICE_TYPE_TABLET'


class CarrierEnum(str, Enum):
    WI_FI_ONLY = 'WI_FI_ONLY'
    WI_FI_AND_CELLULAR = 'WI_FI_AND_CELLULAR'


class MobileOperatingSystemTypeEnum(str, Enum):
    IOS = 'IOS'
    ANDROID = 'ANDROID'
    OS_TYPE_UNKNOWN = 'OS_TYPE_UNKNOWN'


class AppAvailabilityStatusEnum(str, Enum):
    AVAILABLE = 'AVAILABLE'
    NOT_AVAILABLE = 'NOT_AVAILABLE'
    UNPROCESSED = 'UNPROCESSED'


class ModerationStatusEnum(str, Enum):
    ACCEPTED = 'ACCEPTED'
    MODERATION = 'MODERATION'
    REJECTED = 'REJECTED'


class SourceProcessingStatusEnum(str, Enum):
    UNPROCESSED = 'UNPROCESSED'
    PROCESSED = 'PROCESSED'
    EMPTY_RESULT = 'EMPTY_RESULT'


class SourceTypeEnum(str, Enum):
    RETAIL_FEED = 'RETAIL_FEED'


class AdGroupStatusSelectionEnum(str, Enum):
    DRAFT = 'DRAFT'
    MODERATION = 'MODERATION'
    ACCEPTED = 'ACCEPTED'
    REJECTED = 'REJECTED'
    PREACCEPTED = 'PREACCEPTED'


class AdGroupFieldEnum(str, Enum):
    Id = 'Id'
    Name = 'Name'
    CampaignId = 'CampaignId'
    RegionIds = 'RegionIds'
    RestrictedRegionIds = 'RestrictedRegionIds'
    NegativeKeywords = 'NegativeKeywords'
    NegativeKeywordSharedSetIds = 'NegativeKeywordSharedSetIds'
    TrackingParams = 'TrackingParams'
    Status = 'Status'
    ServingStatus = 'ServingStatus'
    Type = 'Type'
    Subtype = 'Subtype'
