from enum import Enum
from crm.supskills.common.direct_client.structs.enums.general import CurrencyEnum


class AdTypeEnum(str, Enum):
    TEXT_AD = 'TEXT_AD'
    SMART_AD = 'SMART_AD'
    MOBILE_APP_AD = 'MOBILE_APP_AD'
    DYNAMIC_TEXT_AD = 'DYNAMIC_TEXT_AD'
    IMAGE_AD = 'IMAGE_AD'
    CPC_VIDEO_AD = 'CPC_VIDEO_AD'
    CPM_BANNER_AD = 'CPM_BANNER_AD'
    CPM_VIDEO_AD = 'CPM_VIDEO_AD'


class AdStateSelectionEnum(str, Enum):
    ARCHIVED = 'ARCHIVED'
    SUSPENDED = 'SUSPENDED'
    ENDED = 'ENDED'
    ON = 'ON'
    OFF = 'OFF'


class AdStatusSelectionEnum(str, Enum):
    DRAFT = 'DRAFT'
    MODERATION = 'MODERATION'
    PREACCEPTED = 'PREACCEPTED'
    ACCEPTED = 'ACCEPTED'
    REJECTED = 'REJECTED'


class ExtensionStatusSelectionEnum(str, Enum):
    DRAFT = 'DRAFT'
    MODERATION = 'MODERATION'
    ACCEPTED = 'ACCEPTED'
    REJECTED = 'REJECTED'
    UNKNOWN = 'UNKNOWN'


class AdFieldEnum(str, Enum):
    Id = 'Id'
    CampaignId = 'CampaignId'
    AdGroupId = 'AdGroupId'
    Status = 'Status'
    State = 'State'
    StatusClarification = 'StatusClarification'
    AdCategories = 'AdCategories'
    AgeLabel = 'AgeLabel'
    Type = 'Type'
    Subtype = 'Subtype'


class AdSubtypeEnum(str, Enum):
    MOBILE_APP_AD_BUILDER_AD = 'MOBILE_APP_AD_BUILDER_AD'
    MOBILE_APP_IMAGE_AD = 'MOBILE_APP_IMAGE_AD'
    MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD = 'MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD'
    TEXT_AD_BUILDER_AD = 'TEXT_AD_BUILDER_AD'
    TEXT_IMAGE_AD = 'TEXT_IMAGE_AD'
    NONE = 'NONE'


class TextAdFieldEnum(str, Enum):
    Title = 'Title'
    Title2 = 'Title2'
    Text = 'Text'
    Href = 'Href'
    Mobile = 'Mobile'
    DisplayDomain = 'DisplayDomain'
    DisplayUrlPath = 'DisplayUrlPath'
    VCardId = 'VCardId'
    SitelinkSetId = 'SitelinkSetId'
    AdImageHash = 'AdImageHash'
    DisplayUrlPathModeration = 'DisplayUrlPathModeration'
    VCardModeration = 'VCardModeration'
    SitelinksModeration = 'SitelinksModeration'
    AdImageModeration = 'AdImageModeration'
    AdExtensions = 'AdExtensions'
    VideoExtension = 'VideoExtension'
    TurboPageId = 'TurboPageId'
    TurboPageModeration = 'TurboPageModeration'
    BusinessId = 'BusinessId'
    PreferVCardOverBusiness = 'PreferVCardOverBusiness'


class TextAdPriceExtensionFieldEnum(str, Enum):
    Price = 'Price'
    OldPrice = 'OldPrice'
    PriceCurrency = 'PriceCurrency'
    PriceQualifier = 'PriceQualifier'


class TextImageAdFieldEnum(str, Enum):
    AdImageHash = 'AdImageHash'
    LogoExtensionHash = 'LogoExtensionHash'
    LogoExtensionModeration = 'LogoExtensionModeration'
    Href = 'Href'
    TurboPageId = 'TurboPageId'
    TurboPageModeration = 'TurboPageModeration'
    ButtonExtensionModeration = 'ButtonExtensionModeration'
    ButtonExtension = 'ButtonExtension'
    Title = 'Title'
    Title2 = 'Title2'
    Text = 'Text'


class TextAdBuilderAdFieldEnum(str, Enum):
    LogoExtensionHash = 'LogoExtensionHash'
    LogoExtensionModeration = 'LogoExtensionModeration'
    Creative = 'Creative'
    Href = 'Href'
    TurboPageId = 'TurboPageId'
    TurboPageModeration = 'TurboPageModeration'
    ButtonExtensionModeration = 'ButtonExtensionModeration'
    ButtonExtension = 'ButtonExtension'
    Title = 'Title'
    Title2 = 'Title2'
    Text = 'Text'


class MobileAppAdFieldEnum(str, Enum):
    AdImageHash = 'AdImageHash'
    Title = 'Title'
    Text = 'Text'
    Features = 'Features'
    Action = 'Action'
    TrackingUrl = 'TrackingUrl'
    ImpressionUrl = 'ImpressionUrl'
    AdImageModeration = 'AdImageModeration'
    VideoExtension = 'VideoExtension'


class MobileAppImageAdFieldEnum(str, Enum):
    AdImageHash = 'AdImageHash'
    TrackingUrl = 'TrackingUrl'


class MobileAppAdBuilderAdFieldEnum(str, Enum):
    Creative = 'Creative'
    TrackingUrl = 'TrackingUrl'


MobileAppCpcVideoAdBuilderAdFieldEnum = MobileAppAdBuilderAdFieldEnum


class DynamicTextAdFieldEnum(str, Enum):
    AdImageHash = 'AdImageHash'
    SitelinkSetId = 'SitelinkSetId'
    Text = 'Text'
    VCardId = 'VCardId'
    AdImageModeration = 'AdImageModeration'
    SitelinksModeration = 'SitelinksModeration'
    VCardModeration = 'VCardModeration'
    AdExtensions = 'AdExtensions'


class CpcVideoAdBuilderAdFieldEnum(str, Enum):
    Creative = 'Creative'
    Href = 'Href'
    TurboPageId = 'TurboPageId'
    TurboPageModeration = 'TurboPageModeration'


class CpmVideoAdBuilderAdFieldEnum(str, Enum):
    LogoExtensionHash = 'LogoExtensionHash'
    LogoExtensionModeration = 'LogoExtensionModeration'
    Creative = 'Creative'
    Href = 'Href'
    TrackingPixels = 'TrackingPixels'
    TurboPageId = 'TurboPageId'
    TurboPageModeration = 'TurboPageModeration'
    TnsId = 'TnsId'
    ButtonExtensionModeration = 'ButtonExtensionModeration'
    ButtonExtension = 'ButtonExtension'
    Title = 'Title'
    Title2 = 'Title2'
    Text = 'Text'


class CpmBannerAdBuilderAdFieldEnum(str, Enum):
    Creative = 'Creative'
    Href = 'Href'
    TrackingPixels = 'TrackingPixels'
    TurboPageId = 'TurboPageId'
    TurboPageModeration = 'TurboPageModeration'
    TnsId = 'TnsId'


class SmartAdBuilderAdFieldEnum(str, Enum):
    Creative = 'Creative'


class AgeLabelEnum(str, Enum):
    MONTHS_0 = 'MONTHS_0'
    MONTHS_1 = 'MONTHS_1'
    MONTHS_2 = 'MONTHS_2'
    MONTHS_3 = 'MONTHS_3'
    MONTHS_4 = 'MONTHS_4'
    MONTHS_5 = 'MONTHS_5'
    MONTHS_6 = 'MONTHS_6'
    MONTHS_7 = 'MONTHS_7'
    MONTHS_8 = 'MONTHS_8'
    MONTHS_9 = 'MONTHS_9'
    MONTHS_10 = 'MONTHS_10'
    MONTHS_11 = 'MONTHS_11'
    MONTHS_12 = 'MONTHS_12'
    AGE_0 = 'AGE_0'
    AGE_6 = 'AGE_6'
    AGE_12 = 'AGE_12'
    AGE_16 = 'AGE_16'
    AGE_18 = 'AGE_18'


class PriceQualifierEnum(str, Enum):
    NONE = 'NONE'
    FROM = 'FROM'
    UP_TO = 'UP_TO'


PriceCurrencyEnum = CurrencyEnum


class MobileAppFeatureEnum(str, Enum):
    PRICE = 'PRICE'
    ICON = 'ICON'
    CUSTOMER_RATING = 'CUSTOMER_RATING'
    RATINGS = 'RATINGS'


class AdExtensionTypeEnum(str, Enum):
    CALLOUT = 'CALLOUT'
    UNKNOWN = 'UNKNOWN'


class MobileAppAdActionEnum(str, Enum):
    DOWNLOAD = 'DOWNLOAD'
    GET = 'GET'
    INSTALL = 'INSTALL'
    MORE = 'MORE'
    OPEN = 'OPEN'
    UPDATE = 'UPDATE'
    PLAY = 'PLAY'
    BUY_AUTODETECT = 'BUY_AUTODETECT'
