from enum import Enum


class BidModifierTypeEnum(str, Enum):
    MOBILE_ADJUSTMENT = 'MOBILE_ADJUSTMENT'
    DESKTOP_ADJUSTMENT = 'DESKTOP_ADJUSTMENT'
    DEMOGRAPHICS_ADJUSTMENT = 'DEMOGRAPHICS_ADJUSTMENT'
    RETARGETING_ADJUSTMENT = 'RETARGETING_ADJUSTMENT'
    REGIONAL_ADJUSTMENT = 'REGIONAL_ADJUSTMENT'
    VIDEO_ADJUSTMENT = 'VIDEO_ADJUSTMENT'
    SMART_AD_ADJUSTMENT = 'SMART_AD_ADJUSTMENT'


class BidModifierLevelEnum(str, Enum):
    CAMPAIGN = 'CAMPAIGN'
    AD_GROUP = 'AD_GROUP'


class MobileAdjustmentFieldEnum(str, Enum):
    BidModifier = 'BidModifier'
    OperatingSystemType = 'OperatingSystemType'


class DesktopAdjustmentFieldEnum(str, Enum):
    BidModifier = 'BidModifier'


class DemographicsAdjustmentFieldEnum(str, Enum):
    Gender = 'Gender'
    Age = 'Age'
    BidModifier = 'BidModifier'
    Enabled = 'Enabled'


class BidModifierFieldEnum(str, Enum):
    Id = 'Id'
    AdGroupId = 'AdGroupId'
    CampaignId = 'CampaignId'
    Level = 'Level'
    Type = 'Type'


class RetargetingAdjustmentFieldEnum(str, Enum):
    RetargetingConditionId = 'RetargetingConditionId'
    Accessible = 'Accessible'
    BidModifier = 'BidModifier'
    Enabled = 'Enabled'


VideoAdjustmentFieldEnum = DesktopAdjustmentFieldEnum


class RegionalAdjustmentFieldEnum(str, Enum):
    RegionId = 'RegionId'
    BidModifier = 'BidModifier'
    Enabled = 'Enabled'


SmartAdAdjustmentFieldEnum = DesktopAdjustmentFieldEnum


class OperatingSystemTypeEnum(str, Enum):
    IOS = 'IOS'
    ANDROID = 'ANDROID'


class GenderEnum(str, Enum):
    IOS = 'GENDER_MALE'
    ANDROID = 'GENDER_FEMALE'


class AgeRangeEnum(str, Enum):
    AGE_0_17 = 'AGE_0_17'
    AGE_18_24 = 'AGE_18_24'
    AGE_25_34 = 'AGE_25_34'
    AGE_35_44 = 'AGE_35_44'
    AGE_45_54 = 'AGE_45_54'
    AGE_45 = 'AGE_45'
    AGE_55 = 'AGE_55'
