from enum import Enum


class DailyBudgetModeEnum(str, Enum):
    STANDARD = 'STANDARD'
    DISTRIBUTED = 'DISTRIBUTED'


class SmsEventsEnum(str, Enum):
    MONITORING = 'MONITORING'
    MODERATION = 'MODERATION'
    MONEY_IN = 'MONEY_IN'
    MONEY_OUT = 'MONEY_OUT'
    FINISHED = 'FINISHED'


class CampaignTypeEnum(str, Enum):
    TEXT_CAMPAIGN = 'TEXT_CAMPAIGN'
    SMART_CAMPAIGN = 'SMART_CAMPAIGN'
    DYNAMIC_TEXT_CAMPAIGN = 'DYNAMIC_TEXT_CAMPAIGN'
    MOBILE_APP_CAMPAIGN = 'MOBILE_APP_CAMPAIGN'
    MCBANNER_CAMPAIGN = 'MCBANNER_CAMPAIGN'
    CPM_BANNER_CAMPAIGN = 'CPM_BANNER_CAMPAIGN'
    CPM_DEALS_CAMPAIGN = 'CPM_DEALS_CAMPAIGN'
    CPM_FRONTPAGE_CAMPAIGN = 'CPM_FRONTPAGE_CAMPAIGN'


CampaignTypeGetEnum = CampaignTypeEnum


class CampaignStateEnum(str, Enum):
    CONVERTED = 'CONVERTED'
    ARCHIVED = 'ARCHIVED'
    SUSPENDED = 'SUSPENDED'
    ENDED = 'ENDED'
    ON = 'ON'
    OFF = 'OFF'
    UNKNOWN = 'UNKNOWN'


CampaignStateGetEnum = CampaignStateEnum


class CampaignStatusPaymentEnum(str, Enum):
    DISALLOWED = 'DISALLOWED'
    ALLOWED = 'ALLOWED'


class CampaignFundsEnum(str, Enum):
    CAMPAIGN_FUNDS = 'CAMPAIGN_FUNDS'
    SHARED_ACCOUNT_FUNDS = 'SHARED_ACCOUNT_FUNDS'


class TextCampaignSettingsEnum(str, Enum):
    ADD_METRICA_TAG = 'ADD_METRICA_TAG'
    ADD_OPENSTAT_TAG = 'ADD_OPENSTAT_TAG'
    ADD_TO_FAVORITES = 'ADD_TO_FAVORITES'
    ENABLE_AREA_OF_INTEREST_TARGETING = 'ENABLE_AREA_OF_INTEREST_TARGETING'
    ENABLE_COMPANY_INFO = 'ENABLE_COMPANY_INFO'
    ENABLE_EXTENDED_AD_TITLE = 'ENABLE_EXTENDED_AD_TITLE'
    ENABLE_SITE_MONITORING = 'ENABLE_SITE_MONITORING'
    EXCLUDE_PAUSED_COMPETING_ADS = 'EXCLUDE_PAUSED_COMPETING_ADS'
    MAINTAIN_NETWORK_CPC = 'MAINTAIN_NETWORK_CPC'
    REQUIRE_SERVICING = 'REQUIRE_SERVICING'
    SHARED_ACCOUNT_ENABLED = 'SHARED_ACCOUNT_ENABLED'
    DAILY_BUDGET_ALLOWED = 'DAILY_BUDGET_ALLOWED'
    CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED = 'CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED'


class MobileAppAdActionEnum(str, Enum):
    DOWNLOAD = 'DOWNLOAD'
    GET = 'GET'
    INSTALL = 'INSTALL'
    MORE = 'MORE'
    OPEN = 'OPEN'
    UPDATE = 'UPDATE'
    PLAY = 'PLAY'
    BUY_AUTODETECT = 'BUY_AUTODETECT'


class StringConditionOperatorEnum(str, Enum):
    CONTAINS_ANY = 'CONTAINS_ANY'
    EQUALS_ANY = 'EQUALS_ANY'
    EXISTS = 'EXISTS'
    GREATER_THAN = 'GREATER_THAN'
    IN_RANGE = 'IN_RANGE'
    LESS_THAN = 'LESS_THAN'
    NOT_CONTAINS_ALL = 'NOT_CONTAINS_ALL'


class AttributionModelEnum(str, Enum):
    LC = 'LC'
    LSC = 'LSC'
    FC = 'FC'
    LYDC = 'LYDC'


class ConditionTypeEnum(str, Enum):
    ITEMS_ALL = 'ITEMS_ALL'
    ITEMS_SUBSET = 'ITEMS_SUBSET'


class AdTargetStateSelectionEnum(str, Enum):
    ON = 'ON'
    OFF = 'OFF'
    SUSPENDED = 'SUSPENDED'
    DELETED = 'DELETED'


class PositionEnum(str, Enum):
    PREMIUMFIRST = 'PREMIUMFIRST'
    PREMIUMBLOCK = 'PREMIUMBLOCK'
    FOOTERFIRST = 'FOOTERFIRST'
    FOOTERBLOCK = 'FOOTERBLOCK'
    P11 = 'P11'
    P12 = 'P12'
    P13 = 'P13'
    P14 = 'P14'
    P21 = 'P21'
    P22 = 'P22'
    P23 = 'P23'
    P24 = 'P24'


class CountryCodeEnum(str, Enum):
    RU = 'RU'
    TR = 'TR'
    UA = 'UA'
    KZ = 'KZ'
    BY = 'BY'
    US = 'US'


class CampaignFieldEnum(str, Enum):
    BlockedIps = 'BlockedIps'
    ExcludedSites = 'ExcludedSites'
    Currency = 'Currency'
    DailyBudget = 'DailyBudget'
    Notification = 'Notification'
    EndDate = 'EndDate'
    Funds = 'Funds'
    ClientInfo = 'ClientInfo'
    Id = 'Id'
    Name = 'Name'
    NegativeKeywords = 'NegativeKeywords'
    RepresentedBy = 'RepresentedBy'
    StartDate = 'StartDate'
    Statistics = 'Statistics'
    State = 'State'
    Status = 'Status'
    StatusPayment = 'StatusPayment'
    StatusClarification = 'StatusClarification'
    SourceId = 'SourceId'
    TimeTargeting = 'TimeTargeting'
    TimeZone = 'TimeZone'
    Type = 'Type'


class TextCampaignFieldEnum(str, Enum):
    CounterIds = 'CounterIds'
    RelevantKeywords = 'RelevantKeywords'
    Settings = 'Settings'
    BiddingStrategy = 'BiddingStrategy'
    PriorityGoals = 'PriorityGoals'
    AttributionModel = 'AttributionModel'


class MobileAppCampaignFieldEnum(str, Enum):
    Settings = 'Settings'
    BiddingStrategy = 'BiddingStrategy'


class DynamicTextCampaignFieldEnum(str, Enum):
    CounterIds = 'CounterIds'
    Settings = 'Settings'
    BiddingStrategy = 'BiddingStrategy'
    PriorityGoals = 'PriorityGoals'
    AttributionModel = 'AttributionModel'


class CpmBannerCampaignFieldEnum(str, Enum):
    CounterIds = 'CounterIds'
    Settings = 'Settings'
    BiddingStrategy = 'BiddingStrategy'
    FrequencyCap = 'FrequencyCap'


class SmartCampaignFieldEnum(str, Enum):
    CounterId = 'CounterId'
    Settings = 'Settings'
    BiddingStrategy = 'BiddingStrategy'
    PriorityGoals = 'PriorityGoals'
    AttributionModel = 'AttributionModel'


class TextCampaignNetworkStrategyTypeEnum(str, Enum):
    AVERAGE_CPC = 'AVERAGE_CPC'
    AVERAGE_CPA = 'AVERAGE_CPA'
    PAY_FOR_CONVERSION = 'PAY_FOR_CONVERSION'
    WB_MAXIMUM_CONVERSION_RATE = 'WB_MAXIMUM_CONVERSION_RATE'
    MAXIMUM_COVERAGE = 'MAXIMUM_COVERAGE'
    NETWORK_DEFAULT = 'NETWORK_DEFAULT'
    SERVING_OFF = 'SERVING_OFF'
    UNKNOWN = 'UNKNOWN'
    WB_MAXIMUM_CLICKS = 'WB_MAXIMUM_CLICKS'
    WEEKLY_CLICK_PACKAGE = 'WEEKLY_CLICK_PACKAGE'
    AVERAGE_ROI = 'AVERAGE_ROI'
    AVERAGE_CRR = 'AVERAGE_CRR'


class MobileAppCampaignSearchStrategyTypeEnum(str, Enum):
    AVERAGE_CPC = 'AVERAGE_CPC'
    AVERAGE_CPI = 'AVERAGE_CPI'
    WB_MAXIMUM_APP_INSTALLS = 'WB_MAXIMUM_APP_INSTALLS'
    HIGHEST_POSITION = 'HIGHEST_POSITION'
    IMPRESSIONS_BELOW_SEARCH = 'IMPRESSIONS_BELOW_SEARCH'
    SERVING_OFF = 'SERVING_OFF'
    UNKNOWN = 'UNKNOWN'
    WB_MAXIMUM_CLICKS = 'WB_MAXIMUM_CLICKS'
    WEEKLY_CLICK_PACKAGE = 'WEEKLY_CLICK_PACKAGE'
    PAY_FOR_INSTALL = 'PAY_FOR_INSTALL'


class MobileAppCampaignNetworkStrategyTypeEnum(str, Enum):
    AVERAGE_CPC = 'AVERAGE_CPC'
    AVERAGE_CPI = 'AVERAGE_CPI'
    NETWORK_DEFAULT = 'NETWORK_DEFAULT'
    MAXIMUM_COVERAGE = 'MAXIMUM_COVERAGE'
    WB_MAXIMUM_APP_INSTALLS = 'WB_MAXIMUM_APP_INSTALLS'
    SERVING_OFF = 'SERVING_OFF'
    UNKNOWN = 'UNKNOWN'
    WB_MAXIMUM_CLICKS = 'WB_MAXIMUM_CLICKS'
    WEEKLY_CLICK_PACKAGE = 'WEEKLY_CLICK_PACKAGE'
    PAY_FOR_INSTALL = 'PAY_FOR_INSTALL'


class MobileAppCampaignSettingsEnum(str, Enum):
    ADD_TO_FAVORITES = 'ADD_TO_FAVORITES'
    ENABLE_AREA_OF_INTEREST_TARGETING = 'ENABLE_AREA_OF_INTEREST_TARGETING'
    DAILY_BUDGET_ALLOWED = 'DAILY_BUDGET_ALLOWED'
    REQUIRE_SERVICING = 'REQUIRE_SERVICING'
    MAINTAIN_NETWORK_CPC = 'MAINTAIN_NETWORK_CPC'
    SHARED_ACCOUNT_ENABLED = 'SHARED_ACCOUNT_ENABLED'
    CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED = 'CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED'


class DynamicTextCampaignSearchStrategyTypeEnum(str, Enum):
    AVERAGE_CPC = 'AVERAGE_CPC'
    AVERAGE_CPA = 'AVERAGE_CPA'
    PAY_FOR_CONVERSION = 'PAY_FOR_CONVERSION'
    WB_MAXIMUM_CONVERSION_RATE = 'WB_MAXIMUM_CONVERSION_RATE'
    HIGHEST_POSITION = 'HIGHEST_POSITION'
    IMPRESSIONS_BELOW_SEARCH = 'IMPRESSIONS_BELOW_SEARCH'
    SERVING_OFF = 'SERVING_OFF'
    UNKNOWN = 'UNKNOWN'
    WB_MAXIMUM_CLICKS = 'WB_MAXIMUM_CLICKS'
    WEEKLY_CLICK_PACKAGE = 'WEEKLY_CLICK_PACKAGE'
    AVERAGE_ROI = 'AVERAGE_ROI'
    AVERAGE_CRR = 'AVERAGE_CRR'


class DynamicTextCampaignNetworkStrategyTypeEnum(str, Enum):
    NETWORK_DEFAULT = 'NETWORK_DEFAULT'
    MAXIMUM_COVERAGE = 'MAXIMUM_COVERAGE'
    WB_MAXIMUM_CONVERSION_RATE = 'WB_MAXIMUM_CONVERSION_RATE'
    WB_MAXIMUM_CLICKS = 'WB_MAXIMUM_CLICKS'
    AVERAGE_CPC = 'AVERAGE_CPC'
    AVERAGE_CPA = 'AVERAGE_CPA'
    PAY_FOR_CONVERSION = 'PAY_FOR_CONVERSION'
    AVERAGE_ROI = 'AVERAGE_ROI'
    AVERAGE_CRR = 'AVERAGE_CRR'
    WEEKLY_CLICK_PACKAGE = 'WEEKLY_CLICK_PACKAGE'
    SERVING_OFF = 'SERVING_OFF'
    UNKNOWN = 'UNKNOWN'


class DynamicTextCampaignSettingsGetEnum(str, Enum):
    ADD_OPENSTAT_TAG = 'ADD_OPENSTAT_TAG'
    ADD_METRICA_TAG = 'ADD_METRICA_TAG'
    ADD_TO_FAVORITES = 'ADD_TO_FAVORITES'
    ENABLE_AREA_OF_INTEREST_TARGETING = 'ENABLE_AREA_OF_INTEREST_TARGETING'
    ENABLE_SITE_MONITORING = 'ENABLE_SITE_MONITORING'
    ENABLE_BEHAVIORAL_TARGETING = 'ENABLE_BEHAVIORAL_TARGETING'
    REQUIRE_SERVICING = 'REQUIRE_SERVICING'
    ENABLE_EXTENDED_AD_TITLE = 'ENABLE_EXTENDED_AD_TITLE'
    ENABLE_COMPANY_INFO = 'ENABLE_COMPANY_INFO'
    SHARED_ACCOUNT_ENABLED = 'SHARED_ACCOUNT_ENABLED'
    DAILY_BUDGET_ALLOWED = 'DAILY_BUDGET_ALLOWED'
    CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED = 'CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED'


class CpmBannerCampaignSearchStrategyTypeEnum(str, Enum):
    SERVING_OFF = 'SERVING_OFF'
    UNKNOWN = 'UNKNOWN'


class CpmBannerCampaignNetworkStrategyTypeEnum(str, Enum):
    MANUAL_CPM = 'MANUAL_CPM'
    WB_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS = 'WB_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS'
    CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS = 'CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS'
    WB_MAXIMUM_IMPRESSIONS = 'WB_MAXIMUM_IMPRESSIONS'
    CP_MAXIMUM_IMPRESSIONS = 'CP_MAXIMUM_IMPRESSIONS'
    WB_AVERAGE_CPV = 'WB_AVERAGE_CPV'
    CP_AVERAGE_CPV = 'CP_AVERAGE_CPV'
    UNKNOWN = 'UNKNOWN'


class CpmBannerCampaignSettingsGetEnum(str, Enum):
    ADD_OPENSTAT_TAG = 'ADD_OPENSTAT_TAG'
    ADD_METRICA_TAG = 'ADD_METRICA_TAG'
    ADD_TO_FAVORITES = 'ADD_TO_FAVORITES'
    ENABLE_AREA_OF_INTEREST_TARGETING = 'ENABLE_AREA_OF_INTEREST_TARGETING'
    ENABLE_SITE_MONITORING = 'ENABLE_SITE_MONITORING'
    REQUIRE_SERVICING = 'REQUIRE_SERVICING'
    SHARED_ACCOUNT_ENABLED = 'SHARED_ACCOUNT_ENABLED'
    DAILY_BUDGET_ALLOWED = 'DAILY_BUDGET_ALLOWED'


class SmartCampaignSearchStrategyTypeEnum(str, Enum):
    AVERAGE_CPC_PER_CAMPAIGN = 'AVERAGE_CPC_PER_CAMPAIGN'
    AVERAGE_CPC_PER_FILTER = 'AVERAGE_CPC_PER_FILTER'
    AVERAGE_CPA_PER_CAMPAIGN = 'AVERAGE_CPA_PER_CAMPAIGN'
    AVERAGE_CPA_PER_FILTER = 'AVERAGE_CPA_PER_FILTER'
    PAY_FOR_CONVERSION_PER_CAMPAIGN = 'PAY_FOR_CONVERSION_PER_CAMPAIGN'
    PAY_FOR_CONVERSION_PER_FILTER = 'PAY_FOR_CONVERSION_PER_FILTER'
    AVERAGE_ROI = 'AVERAGE_ROI'
    AVERAGE_CRR = 'AVERAGE_CRR'
    SERVING_OFF = 'SERVING_OFF'
    UNKNOWN = 'UNKNOWN'


class SmartCampaignNetworkStrategyTypeEnum(str, Enum):
    NETWORK_DEFAULT = 'NETWORK_DEFAULT'
    AVERAGE_CPC_PER_CAMPAIGN = 'AVERAGE_CPC_PER_CAMPAIGN'
    AVERAGE_CPC_PER_FILTER = 'AVERAGE_CPC_PER_FILTER'
    AVERAGE_CPA_PER_CAMPAIGN = 'AVERAGE_CPA_PER_CAMPAIGN'
    AVERAGE_CPA_PER_FILTER = 'AVERAGE_CPA_PER_FILTER'
    PAY_FOR_CONVERSION_PER_CAMPAIGN = 'PAY_FOR_CONVERSION_PER_CAMPAIGN'
    PAY_FOR_CONVERSION_PER_FILTER = 'PAY_FOR_CONVERSION_PER_FILTER'
    AVERAGE_ROI = 'AVERAGE_ROI'
    AVERAGE_CRR = 'AVERAGE_CRR'
    SERVING_OFF = 'SERVING_OFF'
    UNKNOWN = 'UNKNOWN'


class SmartCampaignSettingsGetEnum(str, Enum):
    ADD_TO_FAVORITES = 'ADD_TO_FAVORITES'
    ENABLE_AREA_OF_INTEREST_TARGETING = 'ENABLE_AREA_OF_INTEREST_TARGETING'
    REQUIRE_SERVICING = 'REQUIRE_SERVICING'
    SHARED_ACCOUNT_ENABLED = 'SHARED_ACCOUNT_ENABLED'
    DAILY_BUDGET_ALLOWED = 'DAILY_BUDGET_ALLOWED'


class TextCampaignSearchStrategyTypeEnum(str, Enum):
    HIGHEST_POSITION = 'HIGHEST_POSITION'
    WB_MAXIMUM_CLICKS = 'WB_MAXIMUM_CLICKS'
    WB_MAXIMUM_CONVERSION_RATE = 'WB_MAXIMUM_CONVERSION_RATE'
    AVERAGE_CPC = 'AVERAGE_CPC'
    AVERAGE_CPA = 'AVERAGE_CPA'
    AVERAGE_ROI = 'AVERAGE_ROI'
    AVERAGE_CRR = 'AVERAGE_CRR'
    PAY_FOR_CONVERSION = 'PAY_FOR_CONVERSION'
    PAY_FOR_CONVERSION_CRR = 'PAY_FOR_CONVERSION_CRR'
    WEEKLY_CLICK_PACKAGE = 'WEEKLY_CLICK_PACKAGE'
    SERVING_OFF = 'SERVING_OFF'
    UNKNOWN = 'UNKNOWN'
