"""EmailSubscriptionEnum, LangEnum, PrivilegeEnum, \
    ClientRestrictionEnum, ClientSettingGetEnum"""
from enum import Enum


class EmailSubscriptionEnum(str, Enum):
    RECEIVE_RECOMMENDATIONS = 'RECEIVE_RECOMMENDATIONS'
    TRACK_MANAGED_CAMPAIGNS = 'TRACK_MANAGED_CAMPAIGNS'
    TRACK_POSITION_CHANGES = 'TRACK_POSITION_CHANGES'


class PrivilegeEnum(str, Enum):
    EDIT_CAMPAIGNS = 'EDIT_CAMPAIGNS'
    IMPORT_XLS = 'IMPORT_XLS'
    TRANSFER_MONEY = 'TRANSFER_MONEY'


class ClientRestrictionEnum(str, Enum):
    ADGROUPS_TOTAL_PER_CAMPAIGN = 'ADGROUPS_TOTAL_PER_CAMPAIGN'
    ADS_TOTAL_PER_ADGROUP = 'ADS_TOTAL_PER_ADGROUP'
    API_POINTS = 'API_POINTS'
    CAMPAIGNS_TOTAL_PER_CLIENT = 'CAMPAIGNS_TOTAL_PER_CLIENT'
    CAMPAIGNS_UNARCHIVED_PER_CLIENT = 'CAMPAIGNS_UNARCHIVED_PER_CLIENT'
    FORECAST_REPORTS_TOTAL_IN_QUEUE = 'FORECAST_REPORTS_TOTAL_IN_QUEUE'
    KEYWORDS_TOTAL_PER_ADGROUP = 'KEYWORDS_TOTAL_PER_ADGROUP'
    STAT_REPORTS_TOTAL_IN_QUEUE = 'STAT_REPORTS_TOTAL_IN_QUEUE'
    WORDSTAT_REPORTS_TOTAL_IN_QUEUE = 'WORDSTAT_REPORTS_TOTAL_IN_QUEUE'
    AD_EXTENSIONS_TOTAL = 'AD_EXTENSIONS_TOTAL'
    GENERAL_DOMAIN_BLACKLIST_SIZE = 'GENERAL_DOMAIN_BLACKLIST_SIZE'
    VIDEO_DOMAIN_BLACKLIST_SIZE = 'VIDEO_DOMAIN_BLACKLIST_SIZE'


class ClientSettingGetEnum(str, Enum):
    CORRECT_TYPOS_AUTOMATICALLY = 'CORRECT_TYPOS_AUTOMATICALLY'
    DISPLAY_STORE_RATING = 'DISPLAY_STORE_RATING'
    SHARED_ACCOUNT_ENABLED = 'SHARED_ACCOUNT_ENABLED'


class ClientFieldEnum(str, Enum):
    AccountQuality = 'AccountQuality'
    Archived = 'Archived'
    ClientId = 'ClientId'
    ClientInfo = 'ClientInfo'
    CountryId = 'CountryId'
    CreatedAt = 'CreatedAt'
    Currency = 'Currency'
    Grants = 'Grants'
    Bonuses = 'Bonuses'
    Login = 'Login'
    Notification = 'Notification'
    OverdraftSumAvailable = 'OverdraftSumAvailable'
    Phone = 'Phone'
    Representatives = 'Representatives'
    Restrictions = 'Restrictions'
    Settings = 'Settings'
    Type = 'Type'
    VatRate = 'VatRate'


class RepresentativeRoleEnum(str, Enum):
    CHIEF = 'CHIEF'
    DELEGATE = 'DELEGATE'
    LIMITED = 'LIMITED'
    UNKNOWN = 'UNKNOWN'
