from enum import Enum


class StatusEnum(str, Enum):
    DRAFT = 'DRAFT'
    MODERATION = 'MODERATION'
    ACCEPTED = 'ACCEPTED'
    REJECTED = 'REJECTED'
    PREACCEPTED = 'PREACCEPTED'
    UNKNOWN = 'UNKNOWN'


class StateEnum(str, Enum):
    ON = 'ON'
    OFF = 'OFF'
    SUSPENDED = 'SUSPENDED'
    DELETED = 'DELETED'
    OFF_BY_MONITORING = 'OFF_BY_MONITORING'
    ARCHIVED = 'ARCHIVED'
    UNKNOWN = 'UNKNOWN'


class ServingStatusEnum(str, Enum):
    ELIGIBLE = 'ELIGIBLE'
    RARELY_SERVED = 'RARELY_SERVED'


class YesNoEnum(str, Enum):
    YES = 'YES'
    NO = 'NO'


class YesNoUnknownEnum(str, Enum):
    YES = 'YES'
    NO = 'NO'
    UNKNOWN = 'UNKNOWN'


class PriorityEnum(str, Enum):
    LOW = 'LOW'
    NORMAL = 'NORMAL'
    HIGH = 'HIGH'


class CurrencyEnum(str, Enum):
    RUB = 'RUB'
    CHF = 'CHF'
    EUR = 'EUR'
    KZT = 'KZT'
    TRY = 'TRY'
    UAH = 'UAH'
    USD = 'USD'
    BYN = 'BYN'
    UZS = 'UZS'


class LangEnum(str, Enum):
    RU = 'RU'
    UK = 'UK'
    EN = 'EN'
    TR = 'TR'
