from dataclasses import asdict
from marshmallow_dataclass import class_schema
from marshmallow import EXCLUDE, fields
from crm.supskills.common.direct_client.services import Service


def __delete_none(dict_with_nones: dict):
    if isinstance(dict_with_nones, dict):
        none_free_dict = {}
        for key, value in dict_with_nones.items():
            if value is not None:
                none_free_dict[key] = __delete_none(value)
        return none_free_dict
    elif isinstance(dict_with_nones, list):
        return [__delete_none(item) for item in dict_with_nones]
    else:
        return dict_with_nones


def to_dict(your_class_instance) -> dict:
    return __delete_none(asdict(your_class_instance))


def to_request_dict(your_class_instance, method: str = 'get') -> dict:
    return {'method': method, 'params': to_dict(your_class_instance)}


def make_request_dict(service: Service, dictionary: dict) -> dict:
    return to_request_dict(from_dict(service.params, dictionary), service.method)


def from_dict(your_class_type: type, dictionary: dict):
    none_free_dict = __delete_none(dictionary)
    fields.Field(missing=None, allow_none=True)
    you_class_schema = class_schema(your_class_type)(partial=True, unknown=EXCLUDE)
    ans = you_class_schema.load(none_free_dict, partial=True, unknown=EXCLUDE)
    return ans
