from typing import Any, List
from dataclasses import dataclass, field
from crm.supskills.common.direct_client.structs.parameters.general import LimitOffset
from crm.supskills.common.direct_client.structs.enums.ad_groups import AdGroupTypesEnum, AdGroupStatusSelectionEnum, \
    AdGroupFieldEnum

MobileAppAdGroupFieldEnum = Any
DynamicTextAdGroupFieldEnum = Any
DynamicTextFeedAdGroupFieldEnum = Any
SmartAdGroupFieldEnum = Any
ServingStatusEnum = Any
AdGroupAppIconStatusSelectionEnum = Any


@dataclass
class AdGroupsSelectionCriteria:
    CampaignIds: List[int] = field(default=None)
    Ids: List[int] = field(default=None)
    Types: List[AdGroupTypesEnum] = field(default=None)
    Statuses: List[AdGroupStatusSelectionEnum] = field(default=None)
    ServingStatuses: List[ServingStatusEnum] = field(default=None)
    AppIconStatuses: List[AdGroupAppIconStatusSelectionEnum] = field(default=None)
    NegativeKeywordSharedSetIds: List[int] = field(default=None)


@dataclass
class params:
    SelectionCriteria: AdGroupsSelectionCriteria = field(default=AdGroupsSelectionCriteria())
    FieldNames: List[AdGroupFieldEnum] = field(default_factory=lambda: list(AdGroupFieldEnum))
    MobileAppAdGroupFieldNames: List[MobileAppAdGroupFieldEnum] = field(default=None)
    DynamicTextAdGroupFieldNames: List[DynamicTextAdGroupFieldEnum] = field(default=None)
    DynamicTextFeedAdGroupFieldNames: List[DynamicTextFeedAdGroupFieldEnum] = field(default=None)
    SmartAdGroupFieldNames: List[SmartAdGroupFieldEnum] = field(default=None)
    Page: LimitOffset = field(default=None)
