from dataclasses import dataclass, field
from typing import List
from crm.supskills.common.direct_client.structs.enums.general import YesNoEnum
from crm.supskills.common.direct_client.structs.enums.ads import AdStateSelectionEnum, AdStatusSelectionEnum, \
    AdTypeEnum, ExtensionStatusSelectionEnum, AdFieldEnum, TextAdFieldEnum, TextAdPriceExtensionFieldEnum, \
    MobileAppAdBuilderAdFieldEnum, MobileAppImageAdFieldEnum, MobileAppAdFieldEnum, TextAdBuilderAdFieldEnum, \
    TextImageAdFieldEnum, MobileAppCpcVideoAdBuilderAdFieldEnum, DynamicTextAdFieldEnum, CpcVideoAdBuilderAdFieldEnum, \
    CpmVideoAdBuilderAdFieldEnum, CpmBannerAdBuilderAdFieldEnum, SmartAdBuilderAdFieldEnum
from crm.supskills.common.direct_client.structs.parameters.general import LimitOffset


@dataclass
class AdsSelectionCriteria:
    Ids: List[int] = field(default=None)
    AdGroupIds: List[int] = field(default=None)
    CampaignIds: List[int] = field(default=None)
    States: List[AdStateSelectionEnum] = field(default=None)
    Statuses: List[AdStatusSelectionEnum] = field(default=None)
    Types: List[AdTypeEnum] = field(default=None)
    Mobile: YesNoEnum = field(default=None)
    VCardIds: List[int] = field(default=None)
    SitelinkSetIds: List[int] = field(default=None)
    AdImageHashes: List[int] = field(default=None)
    VCardModerationStatuses: List[ExtensionStatusSelectionEnum] = field(default=None)
    SitelinksModerationStatuses: List[ExtensionStatusSelectionEnum] = field(default=None)
    AdImageModerationStatuses: List[ExtensionStatusSelectionEnum] = field(default=None)
    AdExtensionIds: List[int] = field(default=None)


@dataclass
class params:
    SelectionCriteria: AdsSelectionCriteria = field(default=AdsSelectionCriteria())
    FieldNames: List[AdFieldEnum] = field(default_factory=lambda: list(AdFieldEnum))
    TextAdFieldNames: List[TextAdFieldEnum] = field(default_factory=lambda: list(TextAdFieldEnum))
    TextAdPriceExtensionFieldNames: TextAdPriceExtensionFieldEnum = \
        field(default_factory=lambda: list(TextAdPriceExtensionFieldEnum))
    TextImageAdFieldNames: List[TextImageAdFieldEnum] = field(default_factory=lambda: list(TextImageAdFieldEnum))
    TextAdBuilderAdFieldNames: List[TextAdBuilderAdFieldEnum] = \
        field(default_factory=lambda: list(TextAdBuilderAdFieldEnum))
    MobileAppAdFieldNames: List[MobileAppAdFieldEnum] = field(default_factory=lambda: list(MobileAppAdFieldEnum))
    MobileAppImageAdFieldNames: List[MobileAppImageAdFieldEnum] = \
        field(default_factory=lambda: list(MobileAppImageAdFieldEnum))
    MobileAppAdBuilderAdFieldNames: List[MobileAppAdBuilderAdFieldEnum] = \
        field(default_factory=lambda: list(MobileAppAdBuilderAdFieldEnum))
    MobileAppCpcVideoAdBuilderAdFieldNames: List[MobileAppCpcVideoAdBuilderAdFieldEnum] = \
        field(default_factory=lambda: list(MobileAppCpcVideoAdBuilderAdFieldEnum))
    DynamicTextAdFieldNames: List[DynamicTextAdFieldEnum] = field(default_factory=lambda: list(DynamicTextAdFieldEnum))
    CpcVideoAdBuilderAdFieldNames: List[CpcVideoAdBuilderAdFieldEnum] = \
        field(default_factory=lambda: list(CpcVideoAdBuilderAdFieldEnum))
    CpmBannerAdBuilderAdFieldNames: List[CpmBannerAdBuilderAdFieldEnum] = \
        field(default_factory=lambda: list(CpmBannerAdBuilderAdFieldEnum))
    CpmVideoAdBuilderAdFieldNames: List[CpmVideoAdBuilderAdFieldEnum] = \
        field(default_factory=lambda: list(CpmVideoAdBuilderAdFieldEnum))
    SmartAdBuilderAdFieldNames: List[SmartAdBuilderAdFieldEnum] = \
        field(default_factory=lambda: list(SmartAdBuilderAdFieldEnum))
    Page: LimitOffset = field(default=None)
