from typing import List
from dataclasses import dataclass,  field
from crm.supskills.common.direct_client.structs.parameters.general import LimitOffset
from crm.supskills.common.direct_client.structs.enums.audiencetargets import AudienceTargetFieldEnum, \
    AudienceTargetStateEnum


@dataclass
class AudienceTargetSelectionCriteria:
    Ids: List[int] = field(default=None)
    AdGroupIds: List[int] = field(default=None)
    CampaignIds: List[int] = field(default=None)
    RetargetingListIds: List[int] = field(default=None)
    InterestIds: List[int] = field(default=None)
    States: List[AudienceTargetStateEnum] = field(default=None)


@dataclass
class params:
    SelectionCriteria: AudienceTargetSelectionCriteria = field(default=AudienceTargetSelectionCriteria())
    FieldNames: List[AudienceTargetFieldEnum] = field(default_factory=lambda: list(AudienceTargetFieldEnum))
    Page: LimitOffset = field(default=LimitOffset(**{'Limit': 1, 'Offset': 0}))
