from typing import List
from dataclasses import dataclass,  field
from crm.supskills.common.direct_client.structs.parameters.general import LimitOffset
from crm.supskills.common.direct_client.structs.enums.bidmodifiers import BidModifierTypeEnum, BidModifierLevelEnum, \
    BidModifierFieldEnum, MobileAdjustmentFieldEnum, DemographicsAdjustmentFieldEnum, DesktopAdjustmentFieldEnum, \
    RetargetingAdjustmentFieldEnum, VideoAdjustmentFieldEnum, RegionalAdjustmentFieldEnum, SmartAdAdjustmentFieldEnum


@dataclass
class BidModifiersSelectionCriteria:
    Ids: List[int] = field(default=None)
    AdGroupIds: List[int] = field(default=None)
    CampaignIds: List[int] = field(default=None)
    Types: List[BidModifierTypeEnum] = field(default=None)
    Levels: List[BidModifierLevelEnum] = field(default_factory=lambda: list(BidModifierLevelEnum))


@dataclass
class params:
    SelectionCriteria: BidModifiersSelectionCriteria = field(default=BidModifiersSelectionCriteria())
    FieldNames: List[BidModifierFieldEnum] = field(default_factory=lambda: list(BidModifierFieldEnum))
    MobileAdjustmentFieldNames: List[MobileAdjustmentFieldEnum] =\
        field(default_factory=lambda: list(MobileAdjustmentFieldEnum))
    DesktopAdjustmentFieldNames: List[DesktopAdjustmentFieldEnum] =\
        field(default_factory=lambda: list(DesktopAdjustmentFieldEnum))
    DemographicsAdjustmentFieldNames: List[DemographicsAdjustmentFieldEnum] =\
        field(default_factory=lambda: list(DemographicsAdjustmentFieldEnum))
    RetargetingAdjustmentFieldNames: List[RetargetingAdjustmentFieldEnum] =\
        field(default_factory=lambda: list(RetargetingAdjustmentFieldEnum))
    RegionalAdjustmentFieldNames: List[RegionalAdjustmentFieldEnum] =\
        field(default_factory=lambda: list(RegionalAdjustmentFieldEnum))
    VideoAdjustmentFieldNames: List[VideoAdjustmentFieldEnum] =\
        field(default_factory=lambda: list(VideoAdjustmentFieldEnum))
    SmartAdAdjustmentFieldNames: List[SmartAdAdjustmentFieldEnum] =\
        field(default_factory=lambda: list(SmartAdAdjustmentFieldEnum))
    Page: LimitOffset = field(default=LimitOffset(**{'Limit': 1, 'Offset': 0}))
