from typing import List
from dataclasses import dataclass, field
from crm.supskills.common.direct_client.structs.parameters.general import LimitOffset
from crm.supskills.common.direct_client.structs.enums.general import StatusEnum
from crm.supskills.common.direct_client.structs.enums.campaigns import CampaignTypeEnum, CampaignStateEnum, \
    CampaignStatusPaymentEnum, CampaignFieldEnum, TextCampaignFieldEnum, MobileAppCampaignFieldEnum, \
    DynamicTextCampaignFieldEnum, SmartCampaignFieldEnum, CpmBannerCampaignFieldEnum


@dataclass
class CampaignsSelectionCriteria:
    Ids: List[int] = field(default=None)
    Types: List[CampaignTypeEnum] = field(default=None)
    States: List[CampaignStateEnum] = field(default=None)
    Statuses: List[StatusEnum] = field(default=None)
    StatusesPayment: List[CampaignStatusPaymentEnum] = field(default=None)


@dataclass
class params:
    SelectionCriteria: CampaignsSelectionCriteria = field(default=CampaignsSelectionCriteria())
    FieldNames: List[CampaignFieldEnum] = field(default_factory=lambda: list(CampaignFieldEnum))
    TextCampaignFieldNames: List[TextCampaignFieldEnum] = field(default_factory=lambda: list(TextCampaignFieldEnum))
    MobileAppCampaignFieldNames: List[MobileAppCampaignFieldEnum] = \
        field(default_factory=lambda: list(MobileAppCampaignFieldEnum))
    DynamicTextCampaignFieldNames: List[DynamicTextCampaignFieldEnum] = \
        field(default_factory=lambda: list(DynamicTextCampaignFieldEnum))
    CpmBannerCampaignFieldNames: List[CpmBannerCampaignFieldEnum] = \
        field(default_factory=lambda: list(CpmBannerCampaignFieldEnum))
    SmartCampaignFieldNames: List[SmartCampaignFieldEnum] = field(default_factory=lambda: list(SmartCampaignFieldEnum))
    Page: LimitOffset = field(default=LimitOffset(**{'Limit': 2, 'Offset': 0}))
