from typing import List, Any
from dataclasses import dataclass,  field
from crm.supskills.common.direct_client.structs.parameters.general import LimitOffset
from crm.supskills.common.direct_client.structs.enums.feeds import FeedFieldEnum

UrlFeedFieldEnum = Any
FileFeedFieldEnum = Any


@dataclass
class FeedsSelectionCriteria:
    Ids: List[int] = field(default=None)


@dataclass
class params:
    SelectionCriteria: FeedsSelectionCriteria = field(default=FeedsSelectionCriteria())
    FieldNames: List[FeedFieldEnum] = field(default_factory=lambda: list(FeedFieldEnum))
    UrlFeedFieldNames: List[UrlFeedFieldEnum] = field(default=None)
    FileFeedFieldNames: List[FileFeedFieldEnum] = field(default=None)
    Page: LimitOffset = field(default=LimitOffset(**{'Limit': 1, 'Offset': 0}))
