from typing import List
from dataclasses import dataclass,  field
from crm.supskills.common.direct_client.structs.parameters.general import LimitOffset
from crm.supskills.common.direct_client.structs.enums.general import StatusEnum, ServingStatusEnum
from crm.supskills.common.direct_client.structs.enums.keywords import KeywordStatusSelectionEnum, KeywordFieldEnum


@dataclass
class KeywordsSelectionCriteria:
    Ids: List[int] = field(default=None)
    AdGroupIds: List[int] = field(default=None)
    CampaignIds: List[int] = field(default=None)
    States: List[KeywordStatusSelectionEnum] = field(default=None)
    Statuses: List[StatusEnum] = field(default=None)
    ServingStatuses: List[ServingStatusEnum] = field(default=None)
    ModifiedSince: str = field(default=None)


@dataclass
class params:
    SelectionCriteria: KeywordsSelectionCriteria = field(default=KeywordsSelectionCriteria())
    FieldNames: List[KeywordFieldEnum] = field(default_factory=lambda: list(KeywordFieldEnum))
    Page: LimitOffset = field(default=None)
