from typing import List
from dataclasses import dataclass,  field
from crm.supskills.common.direct_client.structs.parameters.general import LimitOffset
from crm.supskills.common.direct_client.structs.enums.turbopages import TurboPageFieldEnum


@dataclass
class IdsCriteria:
    Ids: List[int] = field(default=None)
    BoundWithHrefs: List[str] = field(default=None)


@dataclass
class params:
    SelectionCriteria: IdsCriteria = field(default=IdsCriteria())
    FieldNames: List[TurboPageFieldEnum] = field(default_factory=lambda: list(TurboPageFieldEnum))
    Page: LimitOffset = field(default=LimitOffset(**{'Limit': 1, 'Offset': 0}))
