from typing import Any, List
from dataclasses import dataclass, field
from crm.supskills.common.direct_client.structs.enums.general import CurrencyEnum

EmailNotificationInfo = Any
SmsNotificationInfo = Any
AccountActionResult = Any


@dataclass
class AccountDayBudgetInfo:
    Amount: float = field(default=None)
    SpendMode: str = field(default=None)


@dataclass
class Account:
    AccountID: int = field(default=None)
    Amount: float = field(default=None)
    AmountAvailableForTransfer: float = field(default=None)
    Currency: CurrencyEnum = field(default=None)
    Login: str = field(default=None)
    Discount: float = field(default=None)
    AgencyName: str = field(default=None)
    AccountDayBudget: AccountDayBudgetInfo = field(default=None)
    SmsNotification: SmsNotificationInfo = field(default=None)
    EmailNotification: EmailNotificationInfo = field(default=None)


@dataclass
class AccountManagementResponse:
    Accounts: List[Account] = field(default=None)
    ActionResult: AccountActionResult = field(default=None)
