from typing import List
from dataclasses import dataclass, field
from crm.supskills.common.direct_client.structs.enums.general import StatusEnum, ServingStatusEnum
from crm.supskills.common.direct_client.structs.enums.ad_groups import ModerationStatusEnum, DeviceTypeEnum, \
    CarrierEnum, MobileOperatingSystemTypeEnum, AppAvailabilityStatusEnum, SourceTypeEnum, AdGroupTypesEnum, \
    SourceProcessingStatusEnum, AdGroupSubtypeEnum
from crm.supskills.common.direct_client.structs.structs.general import ArrayOfString, ArrayOfIntegers


@dataclass
class ExtensionModeration:
    Status: ModerationStatusEnum = field(default=None)
    StatusClarification: str = field(default=None)


@dataclass
class MobileAppAdGroupGet:
    StoreUrl: str = field(default=None)
    TargetDeviceType: List[DeviceTypeEnum] = field(default=None)
    TargetCarrier: CarrierEnum = field(default=None)
    TargetOperatingSystemVersion: str = field(default=None)
    AppIconModeration: ExtensionModeration = field(default=None)
    AppOperatingSystemType: MobileOperatingSystemTypeEnum = field(default=None)
    AppAvailabilityStatus: AppAvailabilityStatusEnum = field(default=None)


@dataclass
class SmartAdGroupGet:
    FeedId: int = field(default=None)
    AdTitleSource: str = field(default=None)
    AdBodySource: str = field(default=None)


@dataclass
class DynamicTextFeedAdGroupGet:
    Source: str = field(default=None)
    FeedId: int = field(default=None)
    SourceType: SourceTypeEnum = field(default=None)
    SourceProcessingStatus: SourceProcessingStatusEnum = field(default=None)


@dataclass
class DynamicTextAdGroupGet:
    DomainUrl: str = field(default=None)
    DomainUrlProcessingStatus: SourceProcessingStatusEnum = field(default=None)


@dataclass
class AdGroupGetItem:
    Id: int = field(default=None)
    Name: str = field(default=None)
    CampaignId: int = field(default=None)
    RegionIds: List[int] = field(default=None)
    RestrictedRegionIds: ArrayOfIntegers = field(default=None)
    NegativeKeywords: ArrayOfString = field(default=None)
    NegativeKeywordSharedSetIds: ArrayOfIntegers = field(default=None)
    TrackingParams: str = field(default=None)
    Status: StatusEnum = field(default=None)
    ServingStatus: ServingStatusEnum = field(default=None)
    Type: AdGroupTypesEnum = field(default=None)
    Subtype: AdGroupSubtypeEnum = field(default=None)
    MobileAppAdGroup: MobileAppAdGroupGet = field(default=None)
    DynamicTextAdGroup: DynamicTextAdGroupGet = field(default=None)
    DynamicTextFeedAdGroup: DynamicTextFeedAdGroupGet = field(default=None)
    SmartAdGroup: SmartAdGroupGet = field(default=None)


@dataclass
class result:
    AdGroups: List[AdGroupGetItem] = field(default=None)
    LimitedBy: int = field(default=None)
