from typing import List
from dataclasses import dataclass, field
from crm.supskills.common.direct_client.structs.structs.general import ArrayOfString
from crm.supskills.common.direct_client.structs.enums.general import StatusEnum, StateEnum, YesNoEnum, YesNoUnknownEnum
from crm.supskills.common.direct_client.structs.enums.ads import AdTypeEnum, AdSubtypeEnum, AgeLabelEnum, \
    PriceQualifierEnum, AdExtensionTypeEnum, PriceCurrencyEnum, MobileAppFeatureEnum, MobileAppAdActionEnum


@dataclass
class ExtensionModeration:
    Status: StatusEnum = field(default=None)
    StatusClarification: str = field(default=None)


@dataclass
class TrackingPixelGetItem:
    TrackingPixel: str = field(default=None)
    Provider: str = field(default=None)


@dataclass
class TrackingPixelGetArray:
    Items: List[TrackingPixelGetItem] = field(default=None)


@dataclass
class AdBuilderAdGetItem:
    CreativeId: int = field(default=None)
    ThumbnailUrl: str = field(default=None)
    PreviewUrl: str = field(default=None)


@dataclass
class SmartAdBuilderAdGet:
    Creative: AdBuilderAdGetItem = field(default=None)


@dataclass
class CpmVideoAdBuilderAdGet:
    Creative: AdBuilderAdGetItem = field(default=None)
    Href: str = field(default=None)
    TrackingPixels: TrackingPixelGetArray = field(default=None)
    TurboPageId: int = field(default=None)
    TurboPageModeration: ExtensionModeration = field(default=None)


@dataclass
class CpcVideoAdBuilderAdGet:
    Creative: AdBuilderAdGetItem = field(default=None)
    Href: str = field(default=None)
    TurboPageId: int = field(default=None)
    TurboPageModeration: ExtensionModeration = field(default=None)


CpmBannerAdBuilderAdGet = CpmVideoAdBuilderAdGet


@dataclass
class MobileAppCpcVideoAdBuilderAdGet:
    Creative: AdBuilderAdGetItem = field(default=None)
    TrackingUrl: str = field(default=None)


MobileAppAdBuilderAdGet = MobileAppCpcVideoAdBuilderAdGet


TextAdBuilderAdGet = CpcVideoAdBuilderAdGet


@dataclass
class MobileAppImageAdGet:
    AdImageHash: str = field(default=None)
    TrackingUrl: str = field(default=None)


@dataclass
class TextImageAdGet:
    AdImageHash: str = field(default=None)
    Href: str = field(default=None)
    TurboPageId: int = field(default=None)
    TurboPageModeration: ExtensionModeration = field(default=None)


@dataclass
class MobileAppAdFeatureGetItem:
    Feature: MobileAppFeatureEnum = field(default=None)
    Enabled: YesNoEnum = field(default=None)
    IsAvailable: YesNoUnknownEnum = field(default=None)


@dataclass
class AdExtensionAdGetItem:
    AdExtensionId: int = field(default=None)
    Type: AdExtensionTypeEnum = field(default=None)


@dataclass
class VideoExtensionGetItem:
    CreativeId: int = field(default=None)
    Status: StatusEnum = field(default=None)
    ThumbnailUrl: str = field(default=None)
    PreviewUrl: str = field(default=None)


@dataclass
class PriceExtensionGetItem:
    Price: int = field(default=None)
    OldPrice: int = field(default=None)
    PriceQualifier: PriceQualifierEnum = field(default=None)
    PriceCurrency: PriceCurrencyEnum = field(default=None)


@dataclass
class DynamicTextAdGet:
    VCardId: int = field(default=None)
    AdImageHash: str = field(default=None)
    SitelinkSetId: int = field(default=None)
    VCardModeration: ExtensionModeration = field(default=None)
    SitelinksModeration: ExtensionModeration = field(default=None)
    AdImageModeration: ExtensionModeration = field(default=None)
    AdExtensions: List[AdExtensionAdGetItem] = field(default=None)
    Text: str = field(default=None)


@dataclass
class MobileAppAdGet:
    Title: str = field(default=None)
    Text: str = field(default=None)
    TrackingUrl: str = field(default=None)
    Action: MobileAppAdActionEnum = field(default=None)
    AdImageHash: str = field(default=None)
    Features: List[MobileAppAdFeatureGetItem] = field(default=None)
    AdImageModeration: ExtensionModeration = field(default=None)


@dataclass
class TextAdGet:
    Title: str = field(default=None)
    Title2: str = field(default=None)
    Text: str = field(default=None)
    Href: str = field(default=None)
    Mobile: YesNoEnum = field(default=None)
    DisplayDomain: str = field(default=None)
    DisplayUrlPath: str = field(default=None)
    VCardId: int = field(default=None)
    SitelinkSetId: int = field(default=None)
    StatusClarification: str = field(default=None)
    AdImageHash: str = field(default=None)
    DisplayUrlPathModeration: ExtensionModeration = field(default=None)
    VCardModeration: ExtensionModeration = field(default=None)
    SitelinksModeration: ExtensionModeration = field(default=None)
    AdImageModeration: ExtensionModeration = field(default=None)
    AdExtensions: List[AdExtensionAdGetItem] = field(default=None)
    VideoExtension: VideoExtensionGetItem = field(default=None)
    PriceExtension: PriceExtensionGetItem = field(default=None)
    TurboPageId: int = field(default=None)
    TurboPageModeration: ExtensionModeration = field(default=None)
    BusinessId: int = field(default=None)
    PreferVCardOverBusiness: YesNoEnum = field(default=None)


@dataclass
class AdGetItem:
    Id: int = field(default=None)
    CampaignId: int = field(default=None)
    AdGroupId: int = field(default=None)
    Status: StatusEnum = field(default=None)
    State: StateEnum = field(default=None)
    StatusClarification: str = field(default=None)
    AdCategories: ArrayOfString = field(default=None)
    AgeLabel: AgeLabelEnum = field(default=None)
    Type: AdTypeEnum = field(default=None)
    Subtype: AdSubtypeEnum = field(default=None)
    TextAd: TextAdGet = field(default=None)
    DynamicTextAd: DynamicTextAdGet = field(default=None)
    MobileAppAd: MobileAppAdGet = field(default=None)
    TextImageAd: TextImageAdGet = field(default=None)
    MobileAppImageAd: MobileAppImageAdGet = field(default=None)
    TextAdBuilderAd: TextAdBuilderAdGet = field(default=None)
    MobileAppAdBuilderAd: MobileAppAdBuilderAdGet = field(default=None)
    MobileAppCpcVideoAdBuilderAd: MobileAppCpcVideoAdBuilderAdGet = field(default=None)
    CpmBannerAdBuilderAd: CpmBannerAdBuilderAdGet = field(default=None)
    CpcVideoAdBuilderAd: CpcVideoAdBuilderAdGet = field(default=None)
    CpmVideoAdBuilderAd: CpmVideoAdBuilderAdGet = field(default=None)
    SmartAdBuilderAd: SmartAdBuilderAdGet = field(default=None)


@dataclass
class result:
    Ads: List[AdGetItem] = field(default=None)
    LimitedBy: int = field(default=None)
